#include "features.h"
#include "svm_classifer_clean.h"
#include "chenLeeCV.h"

SVM_GST gst;
svm_classifer_clean<int,double> svm[NUMBER_OF_MODULES];

void configureSystem(SVM_GST * gst)
{
	gst->path = "../Release/";
	gst->imageListFileName = "testImages.txt";
}
void initSystem(SVM_GST * gst,svm_classifer_clean<int,double>*svm)
{

	int k;
	char modelFilePath[256];

	gst->sampleLable = (int *)malloc(MAX_SAMPLE_SIZE * sizeof(int));
	gst->classLable = (int *)malloc(MAX_SAMPLE_SIZE * sizeof(int));

	gst->feature = (double *)malloc(MAX_SAMPLE_SIZE * sizeof(double));

	gst->nClasses = 10; //7;

	/*Load Module*/
	for (k=0;k< NUMBER_OF_MODULES;k++)
	{
		sprintf(modelFilePath,"%smodel/00%d.mod",gst->path,k);
		svm[k].svm_init_clean(modelFilePath);
	}

}
void svmTest(double * feature, int featureSize, int n, float * scores, svm_classifer_clean<int,double> *svm)
{
	int temp = 6; 
	svm[n].svm_classifier_clean(&temp,feature,scores,featureSize,1);
}
int svmTestCharacter(SVM_GST * gst,svm_classifer_clean<int,double> *svm, ClImage *src, int k)
{
	char * path;
	char * tmpStr;
	int ct, lable, i, len, n;
	int * sampleLable, * classLable;
	double * feature;
	float score; 
	int classFlag, classResult;
	int widthStep;
	widStep= (src->width)*(src->channels);

	sampleLable = gst->sampleLable;
	classLable = gst->classLable;
	path = gst->path;
	gst->featureSize = 96; 

	feature = gst->feature;
	//----------------------------------------------------------------------------------------------------//
	 Combine_Features(feature,  (unsigned char *)src->imageData, widStep, 0, 0,  src->width, src->height);
	//------------------------------------------------------------------------------------------------------// 
     classResult = -1;
	 svmTest(feature, gst->featureSize, 0, &score, svm);
     if(score > 0)		classResult = 0;
	 else 
	 {
	   svmTest(feature, gst->featureSize, 1, &score, svm);
       if(score > 0)		classResult = 1;
	   else 
	   {
		    svmTest(feature, gst->featureSize, 2, &score, svm);
            if(score > 0)		classResult = 2;
			else
			{
				svmTest(feature, gst->featureSize, 3, &score, svm);
                if(score > 0)		classResult = 3;
				else
				{
					svmTest(feature, gst->featureSize, 4, &score, svm);
                    if(score > 0)		classResult = 4;
					else
					{
						svmTest(feature, gst->featureSize, 5, &score, svm);
                        if(score > 0)		classResult = 5;
						else
						{
							svmTest(feature, gst->featureSize, 6, &score, svm);
                            if(score > 0)		classResult = 6;
							else
							{
								svmTest(feature, gst->featureSize, 7, &score, svm);
                                if(score > 0)		classResult = 7;
								else
								{
									svmTest(feature, gst->featureSize, 8, &score, svm);
                                    if(score > 0)		classResult = 8;
									else                classResult = 9;
								}
							}
						}
					}
				}

			}
	   }
	 }

    if (k<2) printf("*");
	else if(k!=6) printf("%d", classResult);
	else printf("%d\n", classResult);

	return classResult;
}
